/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import jade.imtp.leap.ICPException;
import jade.imtp.leap.JICP.JICPAddress;
import jade.imtp.leap.TransportProtocol;
import jade.mtp.TransportAddress;
import java.util.Vector;

public class JICPProtocol
extends TransportProtocol {
    public static final String NAME = "jicp";
    public static final int DEFAULT_PORT = 1099;
    public static final byte COMMAND_TYPE = 0;
    public static final byte RESPONSE_TYPE = 1;
    public static final byte KEEP_ALIVE_TYPE = 2;
    public static final byte GET_ADDRESS_TYPE = 21;
    public static final byte CREATE_MEDIATOR_TYPE = 22;
    public static final byte CONNECT_MEDIATOR_TYPE = 23;
    public static final byte DROP_DOWN_TYPE = 30;
    public static final byte ERROR_TYPE = 100;
    public static final byte DEFAULT_INFO = 0;
    public static final byte COMPRESSED_INFO = 1;
    public static final byte RECIPIENT_ID_PRESENT_INFO = 2;
    public static final byte SESSION_ID_PRESENT_INFO = 4;
    public static final byte DATA_PRESENT_INFO = 8;
    public static final byte RECONNECT_INFO = 16;
    public static final byte OK_INFO = 32;
    public static final byte TERMINATED_INFO = 64;
    public static final String DEFAULT_RECIPIENT_ID = "";
    public static final long DEFAULT_MAX_DISCONNECTION_TIME = 600000L;
    public static final long DEFAULT_RETRY_TIME = 10000L;
    public static final long DEFAULT_KEEP_ALIVE_TIME = 60000L;
    public static final String LOCAL_PORT_KEY = "local-port";
    public static final String LOCAL_HOST_KEY = "local-host";
    public static final String REMOTE_URL_KEY = "remote-url";
    public static final String UNREACHABLE_KEY = "unreachable";
    public static final String RECONNECTION_RETRY_TIME_KEY = "reconnection-retry-time";
    public static final String MAX_DISCONNECTION_TIME_KEY = "max-disconnection-time";
    public static final String KEEP_ALIVE_TIME_KEY = "keep-alive-time";
    public static final String DROP_DOWN_TIME_KEY = "drop-down-time";
    public static final String MEDIATOR_CLASS_KEY = "mediator-class";
    public static final String MEDIATOR_ID_KEY = "mediator-id";
    public static final String OWNER_KEY = "owner";
    public static final String NOT_FOUND_ERROR = "Not-found";
    public static final String NOT_AUTHORIZED_ERROR = "Not-authorized";
    private static JICPProtocol theInstance = new JICPProtocol();

    public static JICPProtocol getInstance() {
        return theInstance;
    }

    public String addrToString(TransportAddress ta) throws ICPException {
        JICPAddress jta = null;
        try {
            jta = (JICPAddress)ta;
        }
        catch (ClassCastException cce) {
            throw new ICPException("The TransportAddress " + ta.toString() + " is not a JICPAddress");
        }
        return jta.toString();
    }

    public TransportAddress stringToAddr(String s) throws ICPException {
        Vector addressFields = this.parseURL(s);
        String protocol = (String)addressFields.elementAt(0);
        if (!NAME.equals(protocol)) {
            throw new ICPException("Unexpected protocol \"" + protocol + "\" when \"" + NAME + "\" was expected.");
        }
        String host = (String)addressFields.elementAt(1);
        String port = (String)addressFields.elementAt(2);
        String file = (String)addressFields.elementAt(3);
        String anchor = (String)addressFields.elementAt(4);
        return new JICPAddress(host, port, file, anchor);
    }

    public TransportAddress buildAddress(String host, String port, String file, String anchor) {
        return new JICPAddress(host, port, file, anchor);
    }

    public String getName() {
        return NAME;
    }
}

